import videojs from 'video.js';
import {
  volumeMutedIcon,
  volumeLowIcon,
  volumeHighIcon,
} from "../../../assets/icons/index.js";
import '../../../styles/volume-button.css';

const Button = videojs.getComponent('Button');

class VolumeButton extends Button {
  constructor(player, options) {
    super(player, options);
    this.controlText('Volume');
  }

  createEl() {
    const el = super.createEl('button', {
      className: 'videojs-drm-button videojs-drm-volume-button'
    });
    
    el.innerHTML = volumeHighIcon;
    
    return el;
  }

  handleClick() {
    if (this.player().muted()) {
      this.player().muted(false);
    } else {
      this.player().muted(true);
    }
  }

  updateVolumeIcon(volume, muted) {
    this.el().innerHTML = muted || volume === 0
      ? volumeMutedIcon
      : volume < 0.5
      ? volumeLowIcon
      : volumeHighIcon;
  }

  ready() {
    super.ready();
    
    // Listen to player volume changes
    this.player().on('volumechange', () => {
      const volume = this.player().volume();
      const muted = this.player().muted();
      this.updateVolumeIcon(volume, muted);
    });

    this.updateVolumeIcon(this.player().volume(), this.player().muted());
  }
}

// Register the component
videojs.registerComponent('VolumeButton', VolumeButton);

export default VolumeButton;



